/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db.types;

import de.willuhn.datasource.db.types.TypeGeneric;
import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TypeLongString
extends TypeGeneric {
    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        Object value = rs.getObject(name);
        if (value != null && value instanceof Reader) {
            Reader r = (Reader)value;
            try {
                StringBuffer sb = new StringBuffer();
                char[] buf = new char[1024];
                int len = 0;
                while ((len = r.read(buf)) != -1) {
                    sb.append(buf, 0, len);
                }
                String string = sb.toString();
                return string;
            }
            catch (IOException ioe) {
                throw new SQLException("unable to read text/longvarchar: " + ioe.getMessage());
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException e) {
                    throw new SQLException("unable to close inputstream: " + e.getMessage());
                }
            }
        }
        return value;
    }

    @Override
    public void set(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 0);
        } else {
            stmt.setString(index, value.toString());
        }
    }
}

